Library ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL; 

entity demux16_sync is
        generic(n:integer := 16);       
        port(
             clk: in std_logic;
             t_valid:in std_logic;
             t_last: in std_logic;
	     output_data0: out std_logic_vector(n-1 downto 0);   
             output_data1: out std_logic_vector(n-1 downto 0);
             output_data2: out std_logic_vector(n-1 downto 0);
             output_data3: out std_logic_vector(n-1 downto 0);
             finish: out std_logic;
             input_data: in std_logic_vector(n-1 downto 0));
end entity demux16_sync;

architecture arch_demux16 of demux16_sync is
      


signal a: natural range 0 to 3 :=0;
signal demux16_data0:std_logic_vector(n-1 downto 0):=(others => '0');

signal demux16_data1:std_logic_vector(n-1 downto 0):=(others => '0');

signal demux16_data2:std_logic_vector(n-1 downto 0):=(others => '0');

signal demux16_data3:std_logic_vector(n-1 downto 0):=(others => '0');





begin

finish <=t_last;
p1: process(clk)
        begin
if (rising_edge(clk)) then
         if (t_valid = '1') then
         
	       if (a=0) then 
	       demux16_data0 <= input_data; 
	       a<=1; 
                            
                                      
               elsif (a=1) then
                demux16_data1 <= input_data;
                 a<=2; 
                           
               elsif (a=2) then
                demux16_data2 <= input_data;
                 a<=3; 
               else
                demux16_data3 <= input_data;
                 a<=0; 
               end if;
         end if;
end if;
end process p1;

p2:process(t_last)
begin
       if(t_last='1') then
           output_data0 <= demux16_data0; 
           output_data1 <= demux16_data1;
           output_data2 <= demux16_data2;
           output_data3 <= demux16_data3;
       end if;

end process p2;


end arch_demux16;


